#pragma once
#include <iostream>
#include <SFML/Graphics.hpp>
#include "Bubble.h"
#include "DrawableEntity.h"

using namespace std;

enum PlayerEventType {
	NONE,
	GRAB,
	THROW
};

class PlayerEvent {
public:
	PlayerEventType type;

	PlayerEvent() {
		type = PlayerEventType::NONE;
	}
};

class ThrowBubbleEvent : public PlayerEvent {
public:
	BubbleType bubbleType;
	int bubbleCount;

	using PlayerEvent::PlayerEvent;

	ThrowBubbleEvent() {
		type = PlayerEventType::THROW;
	}
};

class GrabBubbleEvent: public PlayerEvent {
public:

	using PlayerEvent::PlayerEvent;

	GrabBubbleEvent() {
		type = PlayerEventType::GRAB;
	}
};

class Player : public DrawableEntity {
protected:
	
public:
	BubbleType holdingBubble;
	int holdCount = 0;
	int score = 0;

	using DrawableEntity::DrawableEntity;

	Player(float x, float y) : DrawableEntity(x, y, "Assets/Jimmy.png") {
		sprite.setScale(2, 2);
	}

	PlayerEvent* handleMovement(sf::Event event, float deltaTime) {
		sf::Vector2f curPos = sprite.getPosition();

		if (holdCount > 0 && event.key.code == sf::Keyboard::Up) {
			ThrowBubbleEvent* event = new ThrowBubbleEvent();
			return event;
		}
		else if (event.key.code == sf::Keyboard::Down) {
			GrabBubbleEvent* event = new GrabBubbleEvent();
			return event;
		}
		else if (event.key.code == sf::Keyboard::Right) {
			int newX = curPos.x + 64;
			if (curPos.x > (7 * 64)) newX = 0;
			sprite.setPosition(newX, curPos.y);
		}
		else if (event.key.code == sf::Keyboard::Left) {
			int newX = curPos.x - 64;
			if (curPos.x < 64) newX = 8 * 64;
			sprite.setPosition(newX, curPos.y);
		}

		return new PlayerEvent();
	}
};