#pragma once
#include <iostream>
#include <SFML/Graphics.hpp>
#include "Bubble.h"
#include "DrawableEntity.h"

using namespace std;

sf::Texture moodTextures[5] = {};

class NPC : public DrawableEntity {
private:
public:
	using DrawableEntity::DrawableEntity;

	enum MoodAsset {
		NEUTRAL = 2,
		HAPPY = 3,
		ECSTATIC = 4,
		UNSURE = 1,
		WORRIED = 0
	};

	MoodAsset currentMood = MoodAsset::NEUTRAL;

	NPC (float x, float y) : DrawableEntity(x, y, "Assets/NPC/0.png") {
		sprite.setScale(4, 4);

		for (int i = -2; i <= 2; i++) {
			moodTextures[i + 2].loadFromFile("Assets/NPC/" + to_string(i) + ".png");
		}
	}

	void setMood(MoodAsset mood) {
		currentMood = mood;
		this->setTexture(moodTextures[mood]);
	}
};