#pragma once
#include <iostream>
#include <string.h>
#include <SFML/Graphics.hpp>

using namespace std;

class DrawableEntity {
protected:
	sf::Texture texture;
	sf::Sprite sprite;
public:
	DrawableEntity(float x, float y, string texturePath) {
		if (texturePath.length() > 0 && !texture.loadFromFile(texturePath)) {
			cout << "Error loading texture '" << texturePath << "' for DrawableEntity." << endl;
		}

		sprite.setTexture(texture);
		sprite.setPosition(x, y);
	}

	sf::Sprite getSprite() {
		return sprite;
	}

	void setTexture(sf::Texture& texture) {
		sprite.setTexture(texture, true);
	}

	void setPosition(float x, float y) {
		//cout << x << ":" << y << endl;
		sprite.setPosition(x, y);
	}

	sf::Vector2i getRelativePosition() {
		return sf::Vector2i(sprite.getPosition().x / 64, sprite.getPosition().y / 64);
	}
};