#pragma once
#include <SFML/Graphics.hpp>
#include "DrawableEntity.h"

using namespace std;

const string bubblePopSFX = "Assets/Sounds/General Sounds/Simple Damage Sounds/sfx_damage_hit7.wav";
sf::SoundBuffer bubblePopSFXBuffer;
sf::Sound bubblePopSound;

enum BubbleType {
	RED,
	GREEN,
	BLUE,
	YELLOW
};

class Bubble : public DrawableEntity {
private:
	void setup() {
		sprite.setScale(2, 2);

		if (!bubblePopSound.getBuffer()) {
			if (!bubblePopSFXBuffer.loadFromFile(bubblePopSFX)) {
				cout << "Error loading sound: " << bubblePopSFX << endl;
			}

			bubblePopSound = sf::Sound(bubblePopSFXBuffer);
		}
	}
public:
	BubbleType bubbleType;
	using DrawableEntity::DrawableEntity;

	Bubble(float x, float y, BubbleType _bubbleType) : DrawableEntity(x, y, "Assets/Bubble Base.png") {
		setBubbleType(_bubbleType);
		setup();
	}

	Bubble(float x, float y) : DrawableEntity(x, y, "Assets/Bubble Base.png") {
		setBubbleType((BubbleType)round(rand() % sizeof(BubbleType)));
		setup();
	}

	void popSFX() {
		bubblePopSound.play();
	}

	void setBubbleType(BubbleType type) {
		bubbleType = type;

		switch (type) {
		case BubbleType::RED:
			sprite.setColor(sf::Color::Red);
			break;
		case BubbleType::GREEN:
			sprite.setColor(sf::Color::Green);
			break;
		case BubbleType::BLUE:
			sprite.setColor(sf::Color::Blue);
			break;
		case BubbleType::YELLOW:
			sprite.setColor(sf::Color::Yellow);
			break;
		}
	}
};